/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.content;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.data.element.IngredientData;
import slimeknights.mantle.client.book.data.element.TextData;
import slimeknights.mantle.client.screen.book.Textures;
import slimeknights.mantle.client.screen.book.element.BookElement;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.ItemElement;
import slimeknights.mantle.client.screen.book.element.TextElement;
import slimeknights.mantle.client.screen.book.element.TooltipElement;

public class ContentSmelting
extends PageContent {
    public static final class_2960 ID = Mantle.getResource("smelting");
    private static final class_2371<class_1799> FUELS;
    public static final int TEX_SIZE = 128;
    public static final ImageData IMG_SMELTING;
    public static final int INPUT_X = 5;
    public static final int INPUT_Y = 5;
    public static final int RESULT_X = 74;
    public static final int RESULT_Y = 41;
    public static final int FUEL_X = 5;
    public static final int FUEL_Y = 77;
    public static final float ITEM_SCALE = 2.0f;
    public String title = "Smelting";
    public IngredientData input;
    public IngredientData result;
    public IngredientData fuel;
    public int cookTime = 200;
    public TextData[] description;
    public String recipe;

    @Override
    public void build(BookData book, ArrayList<BookElement> list, boolean rightSide) {
        int y;
        int x = 91 - ContentSmelting.IMG_SMELTING.width / 2;
        if (this.title == null || this.title.isEmpty()) {
            y = 0;
        } else {
            this.addTitle(list, this.title);
            y = this.getTitleHeight();
        }
        list.add(new ImageElement(x, y, ContentSmelting.IMG_SMELTING.width, ContentSmelting.IMG_SMELTING.height, IMG_SMELTING, book.appearance.slotColor));
        list.add(new TooltipElement((List<class_2561>)ImmutableList.of((Object)class_2561.method_43469((String)"mantle:tooltip.cooktime", (Object[])new Object[]{this.cookTime / 20})), x + 7, y + 42, 60, 28));
        if (this.input != null && !this.input.getItems().isEmpty()) {
            list.add(new ItemElement(x + 5, y + 5, 2.0f, (Collection<class_1799>)this.input.getItems(), this.input.action));
        }
        if (this.result != null && !this.result.getItems().isEmpty()) {
            list.add(new ItemElement(x + 74, y + 41, 2.0f, (Collection<class_1799>)this.result.getItems(), this.result.action));
        }
        list.add(new ItemElement(x + 5, y + 77, 2.0f, (Collection<class_1799>)this.getFuelsList()));
        if (this.description != null && this.description.length > 0) {
            list.add(new TextElement(0, ContentSmelting.IMG_SMELTING.height + y + 5, 182, 176 - y - 5, this.description));
        }
    }

    public class_2371<class_1799> getFuelsList() {
        if (this.fuel != null) {
            return this.fuel.getItems();
        }
        return FUELS;
    }

    @Override
    public void load() {
        class_1860 recipe;
        super.load();
        if (!StringUtils.isEmpty((CharSequence)this.recipe) && class_2960.method_20207((String)this.recipe) && (recipe = (class_1860)class_310.method_1551().field_1687.method_8433().method_8130(new class_2960(this.recipe)).orElse(null)) instanceof class_1874) {
            this.input = IngredientData.getItemStackData((class_2371<class_1799>)class_2371.method_10212((Object)class_1799.field_8037, (Object[])((class_1856)recipe.method_8117().get(0)).method_8105()));
            this.cookTime = ((class_1874)recipe).method_8167();
            this.result = IngredientData.getItemStackData(recipe.method_8110(class_310.method_1551().field_1687.method_30349()));
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    static {
        IMG_SMELTING = new ImageData(Textures.TEX_SMELTING, 0, 0, 110, 114, 128, 128);
        FUELS = class_2371.method_10212((Object)class_1799.field_8037, (Object[])new class_1799[]{new class_1799((class_1935)class_2246.field_10119), new class_1799((class_1935)class_2246.field_10071), new class_1799((class_1935)class_2246.field_10257), new class_1799((class_1935)class_2246.field_10617), new class_1799((class_1935)class_2246.field_10031), new class_1799((class_1935)class_2246.field_10500), new class_1799((class_1935)class_2246.field_10161), new class_1799((class_1935)class_2246.field_9975), new class_1799((class_1935)class_2246.field_10148), new class_1799((class_1935)class_2246.field_10334), new class_1799((class_1935)class_2246.field_10218), new class_1799((class_1935)class_2246.field_10075), new class_1799((class_1935)class_2246.field_10381), new class_1799((class_1935)class_1802.field_8647), new class_1799((class_1935)class_1802.field_8091), new class_1799((class_1935)class_1802.field_8167), new class_1799((class_1935)class_1802.field_8600), new class_1799((class_1935)class_1802.field_8713), new class_1799((class_1935)class_1802.field_8187), new class_1799((class_1935)class_2246.field_10394), new class_1799((class_1935)class_2246.field_10217), new class_1799((class_1935)class_2246.field_10575), new class_1799((class_1935)class_2246.field_10276), new class_1799((class_1935)class_2246.field_10385), new class_1799((class_1935)class_2246.field_10160), new class_1799((class_1935)class_1802.field_8894), new class_1799((class_1935)class_1802.field_8876), new class_1799((class_1935)class_1802.field_8406)});
    }
}

